#!/bin/bash
# handlePartition.sh - Creates or deletes partitions on the given device 
# Author: Peter Maier
# Date: 13/Jun/2016

function _alignTo1MiB () {
	local __alignedSector=$1
	local device=$2
	local sector=$3
	local roundUp=$4
	local alignTo=

	if [ -z "$roundUp" ]; then
		logWriteFatal "round up not given"
	fi

	let alignTo=1024*1024		# 1MiB

# read partition info
	OIFS=$IFS
	IFS=$'\n'
	partedOutput=$(parted -s $device unit s print free | sed 's/  */ /g')
	arr=$partedOutput
	nextIsFreeSpace=
	sectorSize=
	for i in $arr
	do
		# read sector size
		if [ -z "$sectorSize" ] ; then
			if [[ "$i" =~ "(logical/physical)" ]]; then
				sectorSize=$(echo $i | cut -d ':' -f 2)
				sectorSize=$(echo $sectorSize | cut -d '/' -f 1)
				sectorSize=${sectorSize// /}		#remove ' '
				sectorSize=${sectorSize//B/}		#remove 'B'
			fi
		fi
	done
	IFS=$OIFS

	let numberOfSectors=$alignTo/$sectorSize

	if [ "$roundUp" = "1" ]; then
		let sector=$sector+$numberOfSectors-1
	fi
	let alignedSector=$sector/$numberOfSectors*$numberOfSectors
	eval $__alignedSector=$alignedSector
}



#####################################################
# Deletes all partition on the given device
#  $1 ... device
#####################################################
function deleteDevice(){
	local device=$1

	logWriteDebugFunction "deleteDevice($device)"

	checkLastParam $device "no device given. deleteDevice($device)"

	# deleting all primary partitions
	logWriteDebugFunctionCall "parted -s $device mklabel msdos"
}

################################################################################################
# Creates a primary  partition on the given device
#  $1 ... device
#  $2 ... log sector size
################################################################################################
function createARembPartition(){
	local device=$1

	logWriteDebugFunction "createARembPartition($device)"

	checkLastParam $device "no device given."

	local systemPartStart=1
	_alignTo1MiB systemPartStart $device $systemPartStart "1"
	systemPartStart=$systemPartStart"s"
	local systemPartEnd="100%"

	logWriteDebugFunctionCall "parted -s $device mkpart primary fat32 $systemPartStart $systemPartEnd"
	logWriteDebugFunctionCall "parted -s $device toggle 1 boot"
	
	getPartitionPrefix partitionPrefix $device
	local partNr=$partitionPrefix"1"
	local devicePartNr=$device$partNr

	logWriteDebugFunctionCall "mkfs -t fat $devicePartNr"
	logWriteDebugFunctionCall "dosfslabel $devicePartNr SYSTEM"
	
	logWriteInfo "Partition for ARemb created"
}

# Resets the master boot record of the given device in order to get EFI working
function resetMBR(){
	local device=$1
	
	logWriteDebugFunction "resetMBR($device)"

	checkLastParam $device "no device given."

	local srcMbrDir=$BASEAR_DIR
	# inclusive the first partition table entry
	logWriteDebugFunctionCall "dd if=/dev/zero of=$device bs=440 count=1"
}
