(*Designition Schritte in den Schrittketten*)

TYPE
	SignalAustausch_typ : 	STRUCT 
		DatenEmpfangen : BOOL; (*Signal an den Empfangsbaustein, dass Daten abgerufen werden*)
		DatenEmpfangenQuit : BOOL; (*Signal an den Ablauf, dass Daten empfangen wurden*)
		DatenSenden : BOOL; (*Signal an den Sendebaustein, dass Daten gesendet werden sollen*)
		DatenSendenQuit : BOOL; (*Signal an den Ablauf, dass Daten gesendet wurden.*)
		DatenVerbindungsaufbau : BOOL; (*TRUE = Verbindung zur Schnittstelle wird aufgebaut, FALSE bestehende Vebrindungen werden getrennt*)
		StatusVerbindungsaufbauSenden : BOOL;
		StatusVerbindungsaufbauEmpfangen : BOOL;
	END_STRUCT;
	RS232Steps : 
		(
		WartenAufStart := 0, (*Schritt aus der Schrittkette RS232 Empfangen warten auf Start*)
		VerbindungOeffnen, (*Schritt aus der Schrittkette RS232 Empfangen Vebrindung ffnen*)
		DatenLesen, (*Schritt aus der Schrittkette RS232 Empfangen Daten auslesen*)
		DatenKopieren, (*Schritt aus der Schrittkette RS232 Empfangen zur bernahme der Daten aus dem Empfangspuffer*)
		FreigabeBuffer, (*Schritt aus der Schrittkette RS232 Empfangen zum freigeben des Empfangspuffers*)
		VerbindungSchliessen, (*Schritt aus der Schrittkette RS232 Empfangen zum Schlieen der Verbindung *)
		Fehler := 255, (*Schritt aus der Schrittkette RS232 Empfangen fr Fehlerbehandlung*)
		SendepufferVorbereiten, (*Defines Step for FRM_rbuf()*)
		DatenVorbereiten, (*Defines Step for preparing send data*)
		DatenSchreiben, (*Defines Step for FRM_write()*)
		WartenAufStartSignal
		);
END_TYPE

(*Komando Struktur*)

TYPE
	Kommandos : 	STRUCT 
		VerbindungOeffnen : BOOL; (*Kommando zum ffnen der Verbindung und start des Lesevorgangs*)
		VerbindungSchliessen : BOOL; (*Kommando zum Schlieen der Verbindung*)
	END_STRUCT;
END_TYPE

(*Strukturen fr Senden und Empfangen*)

TYPE
	Empfaenger_typ : 	STRUCT 
		Schritt : RS232Steps; (*Schritt in der Schrittkette*)
		Kommandos : Kommandos; (*Befehle zur Kommunikation*)
		EmpfangeneDaten : STRING[80]; (*Empfangspuffer*)
		dvframe_xopen_0 : FRM_xopen; (*Funktionsblock aus Bibliothek dvframe FRM_xopen()*)
		dvframe_xopenConfig : XOPENCONFIG; (*Konfigurationsstruktur aus der Bibliothek dvframe FRM_xopen()*)
		dvframe_read_0 : FRM_read; (*Funktionsblock aus Bibliothek dvframe FRM_read()*)
		dvframe_rbuf_0 : FRM_rbuf; (*Funktionsblock aus Bibliothek dvframe FRM_rbuf()*)
		dvframe_close_0 : FRM_close; (*Funktionsblock aus Bibliothek dvframe FRM_close()*)
	END_STRUCT;
	Sender_typ : 	STRUCT 
		Schritt : RS232Steps := (0); (*Step of the Statemachine*)
		Kommandos : Kommandos; (*Commandinterface*)
		SendeDaten : STRING[80]; (*Send data*)
		dvframe_xopen_0 : FRM_xopen; (*Functionblock FRM_xopen()*)
		dvframe_xopenConfig : XOPENCONFIG; (*Configuration Type for FRM_xopen()*)
		dvframe_gbuf_0 : FRM_gbuf; (*Functionblock FRM_gbuf()*)
		dvframe_rbuf_0 : FRM_robuf; (*Functionblock FRM_robuf()*)
		dvframe_write_0 : FRM_write; (*Functionblock FRM_write)*)
		dvframe_close_0 : FRM_close; (*Functionblock FRM_close()*)
	END_STRUCT;
END_TYPE
