(* -------------------------------
	** Projekt		: Lernvideos
	** Hersteller	: Multimedial-Systeme 
	**
	** Bearbeitet durch	
	** Name			: Sebastian Diers
	** Firma		: Multimedial-Systeme	
	**
	** Beschreibung:
	** ber die serielle Schnittstelle sollen Daten empfangen werden und dann
	** mit einem Zusatzvermerkt wieder an den Sender zurck gesendet werden.
	** Der Baustein Ablauf steuert die Bausteine Sender und Empfaenger.
	** Die Schnittstelle wird ber das Bit RS232.KommandoStart aktiviert.
	   -------------------------------*)
PROGRAM _INIT
	
	RS232.Schritt := 0;
	 
END_PROGRAM

PROGRAM _CYCLIC
	
	
	CASE RS232.Schritt OF
		
		DatenWartenAufStart:
		
			//Start der Schrittkette durch Kommando
			IF RS232.KommandoStart = TRUE THEN
				RS232.Schritt := StartenDerVerbindung;
			END_IF			

			
		StartenDerVerbindung:
			
			AblaufSignalAustausch.DatenVerbindungsaufbau := TRUE;
			
			IF (AblaufSignalAustausch.StatusVerbindungsaufbauEmpfangen
				AND AblaufSignalAustausch.StatusVerbindungsaufbauSenden) THEN
				
				RS232.Schritt := StartenEmpfangen;

			END_IF
			
			
			
		StartenEmpfangen:
		
			AblaufSignalAustausch.DatenEmpfangen := TRUE;
			
			IF TRUE THEN
				RS232.Schritt := DatenWurdenEmpfangen;
			END_IF			

		
		
		DatenWurdenEmpfangen:
		
			IF AblaufSignalAustausch.DatenEmpfangenQuit THEN
				AblaufSignalAustausch.DatenEmpfangen := FALSE;
				AblaufSignalAustausch.DatenEmpfangenQuit := FALSE;
				RS232.Schritt := DatenSenden;
			END_IF			

		
		
		DatenSenden:
		
			AblaufSignalAustausch.DatenSenden := TRUE;
			
			IF TRUE THEN
				RS232.Schritt := DatenWurdenGesendet;
			END_IF			

		
		DatenWurdenGesendet:
		
			IF AblaufSignalAustausch.DatenSendenQuit THEN
				AblaufSignalAustausch.DatenSenden := FALSE;
				AblaufSignalAustausch.DatenSendenQuit := FALSE;
				RS232.Schritt := DatenAustauschStatus;
			END_IF			

		
		
		DatenAustauschStatus:
		
			IF RS232.KommandoStart = TRUE THEN
				RS232.Schritt := StartenEmpfangen;
			ELSE
				RS232.Schritt := VebrindungenBeendet;
			END_IF			

		
		VebrindungenBeendet:
			
			AblaufSignalAustausch.DatenVerbindungsaufbau := FALSE;
			
			IF ( NOT (AblaufSignalAustausch.StatusVerbindungsaufbauEmpfangen)
				AND NOT (AblaufSignalAustausch.StatusVerbindungsaufbauSenden)) THEN
				
				RS232.Schritt := DatenWartenAufStart;

			END_IF
					
		
		DatenFehler:
			; 
		//Fehlerbehandlung muss hier programmiert werden
		//Fehlernummern der auslsenden Bausteine auswerten 

		
		
		
		
	END_CASE

	
END_PROGRAM
