(* -------------------------------
	** Projekt		: Lernvideos
	** Hersteller	: Multimedial-Systeme 
	**
	** Bearbeitet durch	
	** Name			: Sebastian Diers
	** Firma		: Multimedial-Systeme	
	**
	**
	   -------------------------------*)
PROGRAM _INIT
	
	Empfaenger.Schritt := WartenAufStart;
	 
END_PROGRAM

PROGRAM _CYCLIC

	CASE Empfaenger.Schritt OF
		
		
		WartenAufStart:
			
			//Start der Schrittkette durch Kommando
			IF (AblaufSignalAustausch.DatenVerbindungsaufbau) THEN
				Empfaenger.Schritt := VerbindungOeffnen;
			END_IF			
		
			
		VerbindungOeffnen:	
			
			//Parameter des Bausteins FRM_xopen()
			Empfaenger.dvframe_xopen_0.enable := TRUE;
			Empfaenger.dvframe_xopen_0.device := ADR('IF6.ST1.IF1');							(*Devicename --> see your serial interface properties*)
			Empfaenger.dvframe_xopen_0.mode := ADR('/PHY=RS232 /BD=19200 /DB=8 /PA=E /SB=1');	(*Modestring --> specifies the seria operation mode*)
			Empfaenger.dvframe_xopen_0.config := ADR(Empfaenger.dvframe_xopenConfig) ;			(*Additional Parameters, optional*)
			
			//Zustzliche Parameter des Bausteins FRM_xopen()
			Empfaenger.dvframe_xopenConfig.idle := 10;											(*Idle time between two characters*)
			Empfaenger.dvframe_xopenConfig.delimc := 0;											(*activate two delimeters*)
			Empfaenger.dvframe_xopenConfig.delim[0] := 0; 										(*e.g. CR - carridge return -> dec 13*)
			Empfaenger.dvframe_xopenConfig.delim[1] := 0; 										(*e.g. LF - line feed -> dec 10*)
			Empfaenger.dvframe_xopenConfig.tx_cnt := 3;											(*number of transmit buffers*)
			Empfaenger.dvframe_xopenConfig.rx_cnt := 3; 										(*number of receive buffers*)
			Empfaenger.dvframe_xopenConfig.tx_len := 256; 										(*length of transmit buffers*)
			Empfaenger.dvframe_xopenConfig.rx_len := 256; 										(*lenght of receive buffers*)
			Empfaenger.dvframe_xopenConfig.argc := 0;											(*activate additional options*)
			Empfaenger.dvframe_xopenConfig.argv := 0;											(*parameters for additional options (check help)*)
		
			//Schnittstelle erfolgreich geffnet
			IF Empfaenger.dvframe_xopen_0.status = StatusFertig THEN
				AblaufSignalAustausch.StatusVerbindungsaufbauEmpfangen := TRUE;
				Empfaenger.Schritt := WartenAufStartSignal;										
				//Baustein noch in Bearbeitung / im aktuellen Schritt bleiben
			ELSIF Empfaenger.dvframe_xopen_0.status = StatusBeschaeftigt THEN
				Empfaenger.Schritt := VerbindungOeffnen;	
				//Wenn der Baustein keinen definierten Zustand hat in den Fehlerschritt gehen
			ELSE
				Empfaenger.Schritt := Fehler;	
			END_IF			
			
		WartenAufStartSignal:
			
			IF (AblaufSignalAustausch.DatenEmpfangen) THEN
				Empfaenger.Schritt := DatenLesen;										
			ELSIF NOT (AblaufSignalAustausch.DatenVerbindungsaufbau) THEN
				Empfaenger.Schritt := VerbindungSchliessen;										
			END_IF
				
			
		DatenLesen:	
			
			//Starten des Lesebausteins
			Empfaenger.dvframe_read_0.enable := TRUE;
			Empfaenger.dvframe_read_0.ident := Empfaenger.dvframe_xopen_0.ident;
			
			//Baustein hat Daten gelesen
			IF Empfaenger.dvframe_read_0.status = StatusFertig THEN
				Empfaenger.Schritt := DatenKopieren;		
				//Baustein meldet keine Daten
			ELSIF Empfaenger.dvframe_read_0.status = frmERR_NOINPUT THEN
				Empfaenger.Schritt := DatenLesen;											
				//Baustein hat falsche Daten gelesen/ Buffer leeren
			ELSIF Empfaenger.dvframe_read_0.status = frmERR_INPUTERROR THEN
				Empfaenger.Schritt := FreigabeBuffer;											
				//Wenn der Baustein keinen definierten Zustand hat in den Fehlerschritt gehen
			ELSE
				Empfaenger.Schritt := Fehler;									
			END_IF			
			
		
		DatenKopieren: 
			
			//Empfangspuffer leeren
			memset(ADR(Empfaenger.EmpfangeneDaten),0,SIZEOF(Empfaenger.EmpfangeneDaten));
			// Daten aus dem Empfangspuffer des Lesebausteins kopieren
			memcpy(ADR(Empfaenger.EmpfangeneDaten),Empfaenger.dvframe_read_0.buffer,Empfaenger.dvframe_read_0.buflng);  
			Empfaenger.Schritt := FreigabeBuffer;																		
		
		FreigabeBuffer:	
		
			//Parametrieren und Starten des Bausteins, der den Lesepuffer wieder freigibt
			Empfaenger.dvframe_rbuf_0.enable := TRUE;
			Empfaenger.dvframe_rbuf_0.ident := Empfaenger.dvframe_xopen_0.ident;				
			Empfaenger.dvframe_rbuf_0.buffer := Empfaenger.dvframe_read_0.buffer;				
			Empfaenger.dvframe_rbuf_0.buflng := Empfaenger.dvframe_read_0.buflng;				
   			
			//Baustein Empfangspuffer freigeben fertig
			IF Empfaenger.dvframe_rbuf_0.status = StatusFertig THEN
				
				AblaufSignalAustausch.DatenEmpfangenQuit := TRUE;
				
				Empfaenger.Schritt := WartenAufStartSignal;											
				
				//Baustein noch in Bearbeitung / im aktuellen Schritt bleiben
			ELSIF Empfaenger.dvframe_rbuf_0.status = StatusBeschaeftigt THEN
				Empfaenger.Schritt := FreigabeBuffer;
				//Rckmeldung dass der Empfangspuffer nicht korrekt ist, dies durch neues Lesen beheben
			ELSIF Empfaenger.dvframe_rbuf_0.status = frmERR_INVALIDBUFFER THEN					
				Empfaenger.Schritt := DatenLesen;
				//Wenn der Baustein keinen definierten Zustand hat in den Fehlerschritt gehen
			ELSE
				Empfaenger.Schritt := Fehler;												
			END_IF			
		
		VerbindungSchliessen:
			
			//Serielle Verbindung schlieen
			Empfaenger.dvframe_close_0.enable := TRUE;
			Empfaenger.dvframe_close_0.ident := Empfaenger.dvframe_xopen_0.ident;								
			
			//Verbindung erfolgreich geschlossen
			IF Empfaenger.dvframe_close_0.status = StatusFertig THEN
				AblaufSignalAustausch.StatusVerbindungsaufbauEmpfangen := FALSE;					
				Empfaenger.Schritt := WartenAufStart;
				//Baustein noch in Bearbeitung / im aktuellen Schritt bleiben
			ELSIF Empfaenger.dvframe_close_0.status = StatusBeschaeftigt THEN
				Empfaenger.Schritt := VerbindungSchliessen;	
				//Wenn der Baustein keinen definierten Zustand hat in den Fehlerschritt gehen
			ELSE
				Empfaenger.Schritt := Fehler;			
			END_IF
			
		Fehler:
			; 
		//Fehlerbehandlung muss hier programmiert werden
		//Fehlernummern der auslsenden Bausteine auswerten 
	END_CASE	


	//Aufruf der Kommunikationsbausteine
	Empfaenger.dvframe_xopen_0();													//Funktion zum ffnen der Verbindung
	Empfaenger.dvframe_read_0();													//Funktion zum Lesen der Daten
	Empfaenger.dvframe_rbuf_0();													//Funktion Zum Freigeben des Empfangspuffers
	Empfaenger.dvframe_close_0();													//Funktion zum Schlieen der Verbindung


	 
END_PROGRAM