(* -------------------------------
	** Projekt		: Lernvideos
	** Hersteller	: Multimedial-Systeme 
	**
	** Bearbeitet durch	
	** Name			: Sebastian Diers
	** Firma		: Multimedial-Systeme	
	**
	**
	   -------------------------------*)
PROGRAM _INIT

	Sender.Schritt := WartenAufStart;
	
END_PROGRAM

PROGRAM _CYCLIC

	CASE Sender.Schritt OF
		
		
		WartenAufStart:	
			
			//Start der Schrittkette durch Kommando
			IF AblaufSignalAustausch.DatenVerbindungsaufbau = TRUE THEN
				Sender.Schritt := VerbindungOeffnen;
			END_IF			
		
		
		VerbindungOeffnen:	

			//Parameter des Bausteins FRM_xopen()
			Sender.dvframe_xopen_0.enable := TRUE;
			Sender.dvframe_xopen_0.device := ADR('IF6.ST1.IF1');								(*Devicename --> see your serial interface properties*)
			Sender.dvframe_xopen_0.mode := ADR('/PHY=RS232 /BD=19200 /DB=8 /PA=E /SB=1'); 		(*Modestring --> specifies the seria operation mode*)
			Sender.dvframe_xopen_0.config := ADR(Sender.dvframe_xopenConfig) ;					(*Additional Parameters, optional*)
			
			//Zustzliche Parameter des Bausteins FRM_xopen()
			Sender.dvframe_xopenConfig.idle := 10;												(*Idle time between two characters*)
			Sender.dvframe_xopenConfig.delimc := 0;												(*activate two delimeters*)
			Sender.dvframe_xopenConfig.delim[0] := 0; 											(*CR - carridge return -> dec 13*)
			Sender.dvframe_xopenConfig.delim[1] := 0; 											(*LF - line feed -> dec 10*)
			Sender.dvframe_xopenConfig.tx_cnt := 3;												(*number of transmit buffers*)
			Sender.dvframe_xopenConfig.rx_cnt := 3; 											(*number of receive buffers*)
			Sender.dvframe_xopenConfig.tx_len := 256; 											(*length of transmit buffers*)
			Sender.dvframe_xopenConfig.rx_len := 256; 											(*lenght of receive buffers*)
			Sender.dvframe_xopenConfig.argc := 0;												(*activate additional options*)
			Sender.dvframe_xopenConfig.argv := 0;												(*parameters for additional options (check help)*)
	
			//Schnittstelle erfolgreich geffnet
			IF Sender.dvframe_xopen_0.status = StatusFertig THEN
				AblaufSignalAustausch.StatusVerbindungsaufbauSenden := TRUE;
				Sender.Schritt := WartenAufStartSignal;
			//Baustein noch in Bearbeitung / im aktuellen Schritt bleiben
			ELSIF Sender.dvframe_xopen_0.status = StatusBeschaeftigt THEN
				Sender.Schritt := VerbindungOeffnen;
			//Wenn der Baustein keinen definierten Zustand hat in den Fehlerschritt gehen
			ELSE
				Sender.Schritt := Fehler;	
			END_IF			
			
			
		WartenAufStartSignal:
			
			IF (AblaufSignalAustausch.DatenSenden) THEN
				Empfaenger.Schritt := SendepufferVorbereiten;										
			ELSIF NOT (AblaufSignalAustausch.DatenVerbindungsaufbau) THEN
				Empfaenger.Schritt := VerbindungSchliessen;										
			END_IF

			
		SendepufferVorbereiten:
			
			//Vorbereiten eines Sendepuffers
			Sender.dvframe_gbuf_0.enable := TRUE;
			Sender.dvframe_gbuf_0.ident := Sender.dvframe_xopen_0.ident;
		
			//Sendepuffer erfolgreich vorbereitet
			IF Sender.dvframe_gbuf_0.status = StatusFertig THEN
				memset(Sender.dvframe_gbuf_0.buffer,0,Sender.dvframe_gbuf_0.buflng);
				Sender.Schritt := DatenVorbereiten;	
			//Baustein noch in Bearbeitung / im aktuellen Schritt bleiben
			ELSIF Sender.dvframe_gbuf_0.status = StatusBeschaeftigt THEN
				Sender.Schritt := SendepufferVorbereiten;			
			ELSE
				Sender.Schritt := Fehler;
			END_IF			
			
		
		DatenVorbereiten: 
		
			//Daten zum senden vorbereiten
			
			//Sende String zusammensetzen
			Sender.SendeDaten := 'Empfangene Daten = ';
			strcat(ADR(Sender.SendeDaten),ADR(Empfaenger.EmpfangeneDaten));	
			strcat(ADR(Sender.SendeDaten),ADR('$R$L'));	
		
			//String in Sendepuffer kopieren
			strcpy(Sender.dvframe_gbuf_0.buffer,ADR(Sender.SendeDaten));
			
			Sender.Schritt := DatenSchreiben;
		
		
		DatenSchreiben:	(*--- write data to interface*)
			
			//Parameter und Starten des Bausteins zum Schreiben der Daten auf die serielle Schnittstelle
			Sender.dvframe_write_0.enable := TRUE;
			Sender.dvframe_write_0.ident := Sender.dvframe_xopen_0.ident;					(*ident from FRM_xopen()*)
			Sender.dvframe_write_0.buffer := Sender.dvframe_gbuf_0.buffer;					(*sendbuffer*)
			Sender.dvframe_write_0.buflng := strlen(ADR(Sender.SendeDaten));				(*net length of senddata*)
   			
			//Baustein fr Daten senden Fertig
			IF Sender.dvframe_write_0.status = StatusFertig THEN

				AblaufSignalAustausch.DatenSendenQuit := TRUE;
				
				Sender.Schritt := FreigabeBuffer;
						
				
			//Baustein noch in Bearbeitung / im aktuellen Schritt bleiben
			ELSIF Sender.dvframe_write_0.status = StatusBeschaeftigt THEN
				Sender.Schritt := DatenSchreiben;	
			//Wenn der Baustein keinen definierten Zustand hat in den Fehlerschritt gehen
			ELSE
				Sender.Schritt := Fehler;
			END_IF			
			
			
		FreigabeBuffer:	
			
			//Parametrieren und Starten des Bausteins, der den Sendepuffer wieder freigibt
			Sender.dvframe_rbuf_0.enable := TRUE;
			Sender.dvframe_rbuf_0.buffer := Sender.dvframe_gbuf_0.buffer;					(*sendbuffer*)
			Sender.dvframe_rbuf_0.buflng := Sender.dvframe_gbuf_0.buflng;					(*buffer length*)
			Sender.dvframe_rbuf_0.ident := Sender.dvframe_xopen_0.ident;					(*ident open*)
		
			//Baustein Sendepuffer freigeben fertig
			IF Sender.dvframe_rbuf_0.status = StatusFertig THEN
				Sender.Schritt := WartenAufStartSignal;
			//Baustein noch in Bearbeitung / im aktuellen Schritt bleiben
			ELSIF Sender.dvframe_rbuf_0.status = StatusBeschaeftigt THEN
				Sender.Schritt := FreigabeBuffer;	
			//Wenn der Baustein keinen definierten Zustand hat in den Fehlerschritt gehen
			ELSE
				Sender.Schritt := Fehler;	
			END_IF			
		
		VerbindungSchliessen:
			
			//Serielle Verbindung schlieen
			Sender.dvframe_close_0.enable := TRUE;
			Sender.dvframe_close_0.ident := Sender.dvframe_xopen_0.ident;					(*ident from FRM_xopen()*)			
			
			//Verbindung erfolgreich geschlossen
			IF Sender.dvframe_close_0.status = StatusFertig THEN
				AblaufSignalAustausch.StatusVerbindungsaufbauSenden := TRUE;
				Sender.Schritt := WartenAufStart;		
				//Baustein noch in Bearbeitung / im aktuellen Schritt bleiben
			ELSIF Sender.dvframe_close_0.status = StatusBeschaeftigt THEN
				Sender.Schritt := VerbindungSchliessen;		
			//Wenn der Baustein keinen definierten Zustand hat in den Fehlerschritt gehen
			ELSE
				Sender.Schritt := Fehler;
			END_IF
			
		Fehler:
			; 
		//Fehlerbehandlung muss hier programmiert werden
		//Fehlernummern der auslsenden Bausteine auswerten 
	END_CASE	
	 
	
	//Aufruf der Kommunikationsbausteine
	Sender.dvframe_xopen_0();													//Funktion zum ffnen der Verbindung
	Sender.dvframe_gbuf_0();													//Funktion um den Sendepuffer vorzubereiten
	Sender.dvframe_write_0();													//Funktion zum Schreiben der Daten
	Sender.dvframe_rbuf_0();													//Funktion Zum Freigeben des Sendepuffers
	Sender.dvframe_close_0();													//Funktion zum Schlieen der Verbindung

	
	
END_PROGRAM