#!/bin/bash

###############################################
# Installs Hypervisor on the given partition
#  $1 ... device
#  $2 ... partition number
###############################################
function installInitialARemb()
{
	local arembDev=$1

	logWriteDebugFunction "installInitialARemb($arembDev)"

	checkLastParam $arembDev "no device given."

	getPartitionPrefix partitionPrefix $arembDev
	local arembPartNr=$partitionPrefix"1"

	local arembSysPart=
	mountPartition arembSysPart $arembDev$arembPartNr
	local arembInstDir=$BASEAR_DIR
	local priModulesDir=$arembSysPart/RPSHD/SYSROM
	local secModulesDir=$arembSysPart/RPSHDS/SYSROM

	# copy inital AR files and project modules
	logWriteDebugFunctionCall "cp -f -r $arembInstDir/* $arembSysPart"
	logWriteDebugFunctionCall "mkdir -p $priModulesDir"
	logWriteDebugFunctionCall "mkdir -p $secModulesDir"
	logWriteDebugFunctionCall "cp -f $arembSysPart/*.br $priModulesDir"
	logWriteDebugFunctionCall "mv -f $arembSysPart/*.br $secModulesDir"
	
	umountDir $arembSysPart

	logWriteInfo "ARemb installed"
}