#!/bin/bash

MIN_AR_PARTITION_SIZE=255			# Mindestgroesse der freien Partition fuer das AR

function _getPipConfig()
{
	local __pipConfig=$1
	local pipCfg
	
	logWriteDebugFunction "_getPipConfig($__pipConfig)"

	checkLastParam $__pipConfig "no pipConfig given."
	
	pipCfg=$(awk -f ${SHELL_SCRIPT_DIR}/getPipConfigFileName.awk $ARNBCFG_FILE)
	pipCfg=$SETUP_DIR"/"$pipCfg

	eval "${__pipConfig}='${pipCfg}'"
}

function _roundUpTo1MiB()
{
	local __roundedSizeInMiB=$1
	local sizeInBytes=$2
	local roundedSizeInMiB=
	let roundTo=1024*1024
	
	logWriteDebugFunction "_roundUpTo1MiB($__roundedSizeInMiB,$sizeInBytes)"

	checkLastParam $sizeInBytes "no sizeInBytes given."
	
	let sizeInBytes=$sizeInBytes+$roundTo-1
	let roundedSizeInMiB=$sizeInBytes/$roundTo
		
	eval "${__roundedSizeInMiB}='${roundedSizeInMiB}'"
}

function getMinPartitionSizes()
{
	local minCFastSize=0
	
	logWriteDebugFunction "getMinPartitionSizes()"

	_getPipConfig pipConfig
	
	local minPartSize1=$(awk -v PARTITION_NUMBER=1 -f ${SHELL_SCRIPT_DIR}/getPartitionSize.awk $pipConfig)
	local minPartSize2=$(awk -v PARTITION_NUMBER=2 -f ${SHELL_SCRIPT_DIR}/getPartitionSize.awk $pipConfig)
	local minPartSize3=$(awk -v PARTITION_NUMBER=3 -f ${SHELL_SCRIPT_DIR}/getPartitionSize.awk $pipConfig)
	local minPartSize4=$(awk -v PARTITION_NUMBER=4 -f ${SHELL_SCRIPT_DIR}/getPartitionSize.awk $pipConfig)
	
	MIN_PART_SIZES=()
	
	_roundUpTo1MiB roundedPartSize $minPartSize1
	let minCFastSize=$roundedPartSize
	MIN_PART_SIZES=("${MIN_PART_SIZES[@]}" "$roundedPartSize")
	if [ -n "$minPartSize2" ]; then
		_roundUpTo1MiB roundedPartSize $minPartSize2
		let minCFastSize=$minCFastSize+$roundedPartSize
		MIN_PART_SIZES=("${MIN_PART_SIZES[@]}" "$roundedPartSize")
		if [ -n "$minPartSize3" ]; then
			_roundUpTo1MiB roundedPartSize $minPartSize3
			let minCFastSize=$minCFastSize+$roundedPartSize
			MIN_PART_SIZES=("${MIN_PART_SIZES[@]}" "$roundedPartSize")
			if [ -n "$minPartSize4" ]; then
				_roundUpTo1MiB roundedPartSize $minPartSize4
				let minCFastSize=$minCFastSize+$roundedPartSize
				MIN_PART_SIZES=("${MIN_PART_SIZES[@]}" "$roundedPartSize")
			fi
		fi
	fi
	MIN_CFAST_SIZE=$minCFastSize

	logWriteDebug "${MIN_CFAST_SIZE}MB needed space"

	if (( MIN_CFAST_SIZE < MIN_AR_PARTITION_SIZE )); then
		MIN_CFAST_SIZE=$MIN_AR_PARTITION_SIZE
	fi

	logWriteDebug "${MIN_CFAST_SIZE}MB minimum CFast size"
}